% Conduct the experiments on multivariate data  in Subsection 4.1 
% using the proposed method and nCor.

clear all
close all

%%%%%%%
N = 200;
% N = 1000;
% N = 5000;
%%%%%%%

M = 50;
P = 10;
R2 = [0.0 0.4 0.8];

rand('state',1)
randn('state',1)

for i = 1:length(R2)
    for j = 1:P
        for k = 1:M
            display([i,j,k])
            x = 2*rand(N,j)-1;
            y = sum(sin(pi*x),2);
            
            e = randn(N,1);
            e = e/std(e);
        
            e1 = .3*e;
            e2 = .2*e.*(sum(x,2)+1.1);
            e3 = .3*e.*sum(cos(pi*x),2);
            e4 = .2*e.*sum((sign(cos(pi*x))+1.5),2);
            
            y1 = R2(i)^.5*y/std(y)+(1-R2(i))^.5*e1/std(e1);
            y2 = R2(i)^.5*y/std(y)+(1-R2(i))^.5*e2/std(e2);
            y3 = R2(i)^.5*y/std(y)+(1-R2(i))^.5*e3/std(e3);
            y4 = R2(i)^.5*y/std(y)+(1-R2(i))^.5*e4/std(e4);
            
            [r1{1,i}(j,k),r2{1,i}(j,k)] = ncor2(x(:,:),y1);
            [r1{2,i}(j,k),r2{2,i}(j,k)] = ncor2(x(:,:),y2);
            [r1{3,i}(j,k),r2{3,i}(j,k)] = ncor2(x(:,:),y3);
            [r1{4,i}(j,k),r2{4,i}(j,k)] = ncor2(x(:,:),y4);
        end
    end
end
